/* colons.c
 *
 * Returns the number of substitution variables in an SQL query.
 */
/* Copyright 1991, 1992, 1993 Kevin Stock.
 *
 * You may copy this under the terms of the GNU General Public License,
 * or the Artistic License, copies of which should have accompanied your
 * Perl kit.
 */

#include <stdio.h>
#include <ctype.h>
#include "EXTERN.h"
#include "orafns.h"


int count_colons(s)
register char *s;
{
	register int n = 0, c;

	DBUG_ENTER("count_colons");
	DBUG_PRINT("entry", ("count_colons(\"%s\")", s));

	while (*s != '\0')
	{
		if (*s == ':')
		{
			/* numbers must be used in sequence,
			 * but they may be repeated if a parameter is reused
			 */

			if (isdigit(*++s))
			{
				if (((c = atoi(s)) <= 0) || (c > n+1))
				{
				    /* number too low or out of sequence */
				    DBUG_PRINT("exit",
				        ("count_colons: got %d, expected %d",
					c, n+1));
				    DBUG_RETURN(-1);
				}
				else if (c == n + 1)
				{
					++n;
				}
				/* else repeating a previous parameter */
			}
			else
			{
				DBUG_PRINT("info", ("ignoring :%c", *s));
			}
		}
		else if (*s == '\'')
		{
			while ((*++s != '\'') && (*s != '\0'))
				;
		}
		if (*s != '\0')
		{
			++s;
		}
	}

	DBUG_PRINT("exit", ("count_colons: returning %d", n));
	DBUG_RETURN(n);
}
