/* debug.c
 * 
 * Translate numeric debugging codes to strings, for Oraperl.
 */
/* Copyright 1991, 1992 Kevin Stock.
 *
 * You may copy this under the terms of the GNU General Public License,
 * or the Artistic License, copies of which should have accompanied your
 * Perl kit.
 */

#include "EXTERN.h"
#include "perl.h"
#include "orafns.h"


/* rules for translating numeric debugging states into strings */

struct	debug_state
{
	int	 level;
	char	*keys;
} debug_states[] =
{
	  8,	",entry,exit,info",
	 32,	",conv",
	128,	",malloc,free",
};

#define	N_DEBUG_STATES	(sizeof(debug_states) / sizeof(*debug_states))


char *
convert_debug(d)
int d;
{
	int i;
	static char state[128];

	DBUG_ENTER("convert_debug");
	DBUG_PRINT("entry", ("convert_debug(%d)", d));

	*state = 'd';
	state[1] = '\0';

	for (i = 0 ; i < N_DEBUG_STATES ; i++)
	{
		if (d & debug_states[i].level)
		{
			strcat(state, debug_states[i].keys);
			DBUG_PRINT("info", ("adding states %s for %d",
				debug_states[i].keys, debug_states[i].level));
		}
	}

	if (state[1] == '\0')
	{
		DBUG_PRINT("exit", ("no debugging states, returning NULL"));
		DBUG_RETURN(NULL);
	}
	else
	{
		strcat(state, ":t:N");		/* nesting and line numbers */
		DBUG_PRINT("exit", ("returning: %s", state));
		DBUG_RETURN(state);
	}
}
