#!./oraperl
#
# install.pl
#
# Perl script to install Oraperl, Coraperl (if present) and sql.
# Hacked from Larry's installperl script in the Perl distribution.

($nonono = 1, shift) if $ARGV[0] eq '-n';
$SRC = shift || die "Usage: $0 [-n] perl_source_directory";

umask 022;

@scripts = ('examples/sql');

# Read in the config file.

open(CONFIG, "${SRC}/config.sh") || die "Can't find Perl's config.sh\n";
while (<CONFIG>) {
    if (s/^(\w+=)/\$$1/) {
	$accum =~ s/'undef'/undef/g;
	eval $accum;
	$accum = '';
    }
    $accum .= $_;
}

# Do some quick sanity checks.

   $installbin		|| die "No installbin directory in config.sh\n";
-d $installbin		|| die "$installbin is not a directory\n";
-w $installbin		|| die "$installbin is not writable by you\n"
	unless $installbin =~ m#^/afs/#;

-x 'oraperl'		|| die "oraperl isn't executable!\n";
-f 'coraperl' && ! -x 'coraperl' && die "coraperl isn't executable!\n";

# Install oraperl (and coraperl if it exists)

&unlink("$installbin/oraperl");
&cmd("cp oraperl $installbin/oraperl");

if (-f 'coraperl')
{
	&unlink("$installbin/coraperl");
	&cmd("cp coraperl $installbin/coraperl");
}


# Install scripts.

&makedir($installscr);

for (@scripts) {
    &cmd("cp $_ $installscr");
    s#.*/##; &chmod(0755, "$installscr/$_");
}


# Install man pages.

if ($mansrc ne '') {
    &makedir($mansrc);

    ($mdev,$mino) = stat($mansrc);
    if ($mdev != $ddev || $mino != $dino) {
	&cmd("cp doc/oraperl.1 $mansrc/oraperl.$manext");
	if (-f 'coraperl')
	{
	    &unlink("$mansrc/coraperl.$manext") if (-f 'coraperl');
	    &link("$mansrc/oraperl.$manext", "$mansrc/coraperl.$manext");
	}
	&cmd("cp examples/sql $mansrc/sql.$manext");
    }
}


# Install library files.

&makedir($installprivlib);
&cmd("cp oraperl.ph $installprivlib");

print STDERR "  Installation complete\n";

exit 0;

###############################################################################

sub unlink {
    local(@names) = @_;

    foreach $name (@names) {
	next unless -e $name;
	print STDERR "  unlink $name\n";
	unlink($name) || warn "Couldn't unlink $name: $!\n" unless $nonono;
    }
}

sub cmd {
    local($cmd) = @_;
    print STDERR "  $cmd\n";
    unless ($nonono) {
	system $cmd;
	warn "Command failed!!!\n" if $?;
    }
}

sub link {
    local($from,$to) = @_;

    print STDERR "  ln $from $to\n";
    link($from,$to) || warn "Couldn't link $from to $to: $!\n" unless $nonono;
}

sub chmod {
    local($mode,$name) = @_;

    printf STDERR "  chmod %o %s\n", $mode, $name;
    chmod($mode,$name) || warn "Couldn't chmod $mode $name: $!\n"
	unless $nonono;
}

sub makedir {
    local($dir) = @_;
    unless (-d $dir) {
	local($shortdir) = $dir;

	$shortdir =~ s#(.*)/.*#$1#;
	&makedir($shortdir);

	print STDERR "  mkdir $dir\n";
	mkdir($dir, 0777) || warn "Couldn't create $dir: $!\n" unless $nonono;
    }
}
