/* orafns.h
 *
 * Common declarations for the Oraperl functions
 */
/* Copyright 1991, 1992, 1993 Kevin Stock.
 *
 * You may copy this under the terms of the GNU General Public License,
 * or the Artistic License, copies of which should have accompanied your
 * Perl kit.
 */


/* public functions to be called by Perl programs */

void		ora_version();

int		ora_fetch(),
		ora_titles();

char		*ora_login(),
		*ora_open(),
		*ora_close(),
		*ora_logoff(),
		*ora_commit(),
		*ora_rollback(),
		*ora_autocommit();

long		ora_do(),
		ora_bind();


/* These functions are internal to the system, not for public consumption */

int		ora_dropcursor(),
		ora_droplda();

char		*convert_debug();

struct	cursor	*ora_getcursor(),
		*ora_getlda();


/* definition of the csrdef structure - taken from the oracle sample program */

struct csrdef
{
   short	  csrrc;				  /* return code */
   short	  csrft;				/* function type */
   unsigned long  csrrpc;			 /* rows processed count */
   short	  csrpeo;			   /* parse error offset */
   unsigned char  csrfc;				/* function code */
   unsigned char  csrfil;				      /* filler  */
   unsigned short csrarc;			    /* reserved, private */
   unsigned char  csrwrn;				/* warning flags */
   unsigned char  csrflg;				  /* error flags */
   /*		     *** Operating system dependent *** 		 */
   unsigned int   csrcn;				/* cursor number */
   struct {					      /* rowid structure */
     struct {
	unsigned long	tidtrba;	   /* rba of first blockof table */
	unsigned short	tidpid; 		/* partition id of table */
	unsigned char	tidtbl; 		    /* table id of table */
	}		ridtid;
     unsigned long   ridbrba;			     /* rba of datablock */
     unsigned short  ridsqn;	      /* sequence number of row in block */
     } csrrid;
   unsigned int   csrose;		      /* os dependent error code */
   unsigned char  csrchk;				   /* check byte */
   unsigned char  crsfill[26];		       /* private, reserved fill */
};


/* data structure for the pool of cursors */

struct	cursor
{
	struct	csrdef	*csr;
	char		*hda,		/* used if this cursor is an lda     */
			**data;		/* used to receive database contents */
	short		**rcode,	/* used to receive fetch error codes */
			*type,		/* used to receive data types	     */
			*len;		/* used to receive field lengths     */
	int		cache_size,	/* how many rows to cache	     */
			end_of_data,	/* reached end of data?		     */
			in_cache,	/* how many rows actually cached     */
			next_entry,	/* next valid cache entry	     */
			nfields,	/* number of fields to retrieve	     */
			varfields;	/* number of modifiable variables    */
	struct	cursor	*next,		/* list pointer			     */
			*parent;	/* lda related to this csr	     */
};


/* functions that we use */

int		count_colons();
unsigned long	strtoul();
char		*getenv();
void		my_setenv();

#ifndef	MALLOC_PTR_TYPE
#	define	MALLOC_PTR_TYPE	char
#endif

MALLOC_PTR_TYPE	*malloc();

/* variables accesible to the outside world */

EXT	struct					/* code & lda of last error  */
	{
		int		no;
		struct	cursor	*lda;
	} ora_err
#ifdef	DOINIT
		 = { 0, NULL }
#endif
				;		/* ends decl of ora_err	     */

EXT	int	ora_long	INIT(80),	/* length of LONG fields     */
		ora_nfields	INIT(0),	/* size of ora_result array  */
		ora_trunc	INIT(0);	/* allow LONG truncation?    */

EXT	char	*ora_debug	INIT(NULL),	/* debugging state	     */
		**ora_result	INIT(NULL);	/* data return		     */


/* How many rows should we cache for a SELECT statement?
 * I think that 5 is a good tradeoff between speed and memory use.
 * If you want a different figure, change it in Makefile, not here.
 */

#ifndef	CACHE_SIZE
#	define CACHE_SIZE	5
#endif

EXT	int	ora_cache	INIT(CACHE_SIZE);	/* default row cache */


/* I've tried to give debugging some compatibility with Larry's -D flag,
 * but allowing the flexibility to debug the oracle functions without
 * debugging perl as well.
 *
 * Look at the file Debugging for details.
 */

#ifdef	PERL_DEBUGGING
#	ifndef	DEBUGGING
#		define	DEBUGGING	/* PERL_DEBUGGING implies DEBUGGING */
#	endif

	extern	int	debug;		/* -D flag from uperl.o	*/
	extern	char	*origfilename;	/* script name		*/
#endif

#ifdef	DEBUGGING
#	ifdef	DBUG_OFF
#		undef	DBUG_OFF
#	endif
#else
#	define	DBUG_OFF
EXT	int	warn_on_debug;
#endif

#include "dbug.h"	/* Yes, this is _outside_ the #ifdef ... #endif */


/* error codes for ORAPERL
 *
 * These are higher than any possible ORACLE error code,
 * so that they can be distinguished
 */

#define	ORAP_ERRMIN	100000	/* lowest value allowed for an oraperl error */
#define	ORAP_ERR(n)	(ORAP_ERRMIN + (n))

#define	ORAP_NOMEM	ORAP_ERR(1)	/* out of memory		    */
#define	ORAP_INVCSR	ORAP_ERR(2)	/* invalid cursor supplied	    */
#define	ORAP_INVLDA	ORAP_ERR(3)	/* invalid lda supplied		    */
#define	ORAP_NOSID	ORAP_ERR(4)	/* couldn't set ORACLE_SID	    */
#define	ORAP_BADVAR	ORAP_ERR(5)	/* bad colon variable sequence	    */
#define	ORAP_NUMVARS	ORAP_ERR(6)	/* wrong number of colon variables  */
#define	ORAP_NODATA	ORAP_ERR(7)	/* statement does not return data   */

#define	ORAP_ERRMAX	ORAP_NODATA	/* highest value actually used	    */
