/* usersub.c
 * 
 * Initialisation for Oraperl.
 */
/* Copyright 1991, 1992, 1993 Kevin Stock.
 *
 * You may copy this under the terms of the GNU General Public License,
 * or the Artistic License, copies of which should have accompanied your
 * Perl kit.
 */

#include "EXTERN.h"
#include "perl.h"
#include "orafns.h"
#include "patchlevel.h"


int
userinit()
{
#ifdef	PERL_DEBUGGING
    char *s;
#endif

    DBUG_ENTER("userinit");
    DBUG_PROCESS(origfilename);
    DBUG_PRINT("entry", ("userinit(void)"));

    init_oracle();
#ifdef CURSES
    init_curses();
#endif

#ifdef DEBUGGING
#   ifdef PERL_DEBUGGING
	if (debug)
	{
		if ((s = convert_debug(debug)) != NULL)
		{
			DBUG_PUSH(s);
			if ((ora_debug = malloc(strlen(s) + 1)) == NULL)
			{
				DBUG_PRINT("malloc",
				    ("insufficient memory for ora_debug"));
				fatal("insufficient memory for ora_debug");
			}
			DBUG_PRINT("malloc", ("got ora_debug %d bytes at %lx",
				strlen(s) + 1, (long) ora_debug));
			strcpy(ora_debug, s);
		}
	}
	else
	{
		ora_debug = NULL;
	}
#   else
	ora_debug = NULL;
#   endif
#else
	warn_on_debug = dowarn;
#endif

    ora_err.no = 0;
    ora_err.lda = NULL;

    DBUG_VOID_RETURN;
}


/* void	ora_version()
 *
 * Print out information about Oraperl.
 * This function is here so that we only recompile one file for curses.
 * Messy, isn't it!
 */

#ifdef	CURSES
#	define	Prog	"Coraperl"
#	define	prog	"coraperl"
#else
#	define	Prog	"Oraperl"
#	define	prog	"oraperl"
#endif

void	ora_version()
{
	DBUG_ENTER("ora_version");

	/* Identify the program and its version */

	printf("\nThis is %s, version %d, patch level %d.\n\n",
		Prog, VERSION, PATCHLEVEL);

	/* Show the compilation-time options */

	printf("Debugging is%s available%s%s.\n",
#ifdef	DEBUGGING
		"",
#	ifdef	PERL_DEBUGGING
		", including ",
#	else
		", without ",
#	endif
		"the -D flag"
#else
		" not", "", ""
#endif
	);
	printf("Default fetch row cache size is %d.\n", CACHE_SIZE);
	printf("Empty bind values %s.\n",
#ifdef	NO_BIND_PADDING
		"cause an error"
#else
		"are replaced by a space"
#endif
	);

	/* Display the copyright information */

	printf("\nPerl is copyright by Larry Wall; type %s -v for details.\n",
		prog);
	printf("Additions for %s: Copyright 1991, 1992, 1993, Kevin Stock.\n",
		prog);

	printf("\n%s may be distributed under the same conditions as Perl.\n\n",
		Prog);

	DBUG_VOID_RETURN;
}
